#include<bits/stdc++.h>

using namespace std;

const int MAX = 3005;

const long long inf = (long long) 1e18;

vector<int> my[MAX];

int n, res[MAX][MAX];

bool has[MAX][MAX];

vector<pair<int, int>> g[MAX];

long long dist[MAX];

void Dijkstra(int del) {
  for (int i = 0; i < n; i++) {
    dist[i] = inf;
  }
  set<pair<long long, int>> st;
  dist[0] = 0;
  st.emplace(0, 0);
  while (!st.empty()) {
    auto it = st.begin();
    int i = it->second;
    st.erase(it);
    for (auto& e : g[i]) {
      int to = e.first;
      int w = e.second;
      if (to == del) {
        continue;
      }
      if (dist[to] > dist[i] + w) {
        if (dist[to] != inf) {
          st.erase({dist[to], to});
        }
        dist[to] = dist[i] + w;
        st.emplace(dist[to], to);
      }
    }
  }
}

void Putevi(int n, int m, int Q, int* U, int* V, int* W, int* X, int* Y, int* Ans) {
  if (m == n - 1) {
    vector<vector<int>> g(n);
    for (int i = 1; i <= m; i++) {
      --U[i]; --V[i];
      g[U[i]].push_back(V[i]);
      g[V[i]].push_back(U[i]);
    }
    const int L = 20;
    vector<vector<int>> jump(n, vector<int>(L));
    vector<int> dep(n);

    function<void(int, int)> Dfs = [&](int v, int pv) {
      dep[v] = dep[pv] + 1;
      jump[v][0] = pv;
      for (int i = 1; i < L; i++) {
        jump[v][i] = jump[jump[v][i - 1]][i - 1];
      }
      for (int u : g[v]) {
        if (u == pv) {
          continue;
        }
        Dfs(u, v);
      }
    };
    Dfs(0, 0);
    auto LCA = [&](int x, int y) {
      if (dep[x] < dep[y]) {
        swap(x, y);
      }
      for (int i = L - 1; i >= 0; i--) {
        if (dep[jump[x][i]] >= dep[y]) {
          x = jump[x][i];
        }
      }
      if (x == y) {
        return x;
      }
      for (int i = L - 1; i >= 0; i--) {
        if (jump[x][i] != jump[y][i]) {
          x = jump[x][i];
          y = jump[y][i];
        }
      }
      return jump[x][0];
    };
    for (int i = 1; i <= Q; i++) {
      --X[i]; --Y[i];
      Ans[i] = dep[LCA(X[i], Y[i])];
    }
    return;
  }
  ::n = n;
  if ((m > 15) && (n > 3000 || m > 3000)) {
    return;
  }
  for (int i = 1; i <= m; i++) {
    --U[i]; --V[i];
    g[U[i]].emplace_back(V[i], W[i]);
    g[V[i]].emplace_back(U[i], W[i]);
  }
  Dijkstra(-1);
  vector<long long> d(n);
  for (int i = 0; i < n; i++) {
    d[i] = dist[i];
  }
  for (int i = 0; i < n; i++) {
    my[i].push_back(0);
  }
  for (int v = 1; v < n; v++) {
    Dijkstra(v);
    for (int i = 0; i < n; i++) {
      if (dist[i] != d[i]) {
        my[i].push_back(v);
      }
    }
  }
  for (int i = 0; i < n; i++) {
    for (int j : my[i]) {
      has[i][j] = true;
    }
  }
  for (int i = 1; i <= Q; i++) {
    int x = X[i], y = Y[i];
    --x; --y;
    if (x > y) {
      swap(x, y);
    }
    if ((int) my[x].size() > (int) my[y].size()) {
      swap(x, y);
    }
    if (res[x][y] > 0) {
      Ans[i] = res[x][y];
      continue;
    }
    int total = 0;
    for (int j : my[x]) {
      if (has[y][j]) {
        total += 1;
      }
    }
    Ans[i] = total;
    res[x][y] = total;
  }
}

/*
4 5 3
1 2 2
2 3 3
2 4 5
1 3 5
4 3 4
2 4
3 4
2 2
*/